from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

class WorseAndWorse2(Player):
    """
    Plays as tit for tat during the first 20 moves.
    Then defects with probability (current turn - 20) / current turn.
    Therefore it is more and more likely to defect as the round goes on.

    Names:
        - Worse and Worse 2: [Prison1998]_
    """

    name = "Worse and Worse 2"
    classifier = {
        "memory_depth": float("inf"),
        "stochastic": True,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def strategy(self, opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        current_round = len(self.history) + 1

        if current_round == 1:
            return C
        elif current_round <= 20:
            return opponent.history[-1]
        else:
            probability = 20 / current_round
            return self._random.random_choice(probability)